// PCIE_TG.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "PCIE_TG.h"
#include "pcitglib.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

pcitg_t ptg_board_0;
char line_cmd[16] = "";

void Command_List()
{
	//system("cls");
	printf("[ Press Command ]\n");
	printf("***********************************\n");
	printf("1 : Set Output Data [0x55]\n");
	printf("2 : Set Output Data [0xAA]\n");
	printf("3 : Get Input  Data \n");
	printf("Q : Quit\n\n");	
	printf("***********************************\n");
	printf(">");
}

int _tmain(int argc, TCHAR* argv[])
{
	int  exit = 0;
	char cmd_0 = 0;
	DWORD nvalue = 0;

	ptg_board_0 = pcitg_open(0);
	if (ptg_board_0 == 0)
	{
		printf("No PCIE-TG Adapter found on the system.\n\n");
		 system("pause");
		 return 0;
	}
	else{
		printf("PCIE - TG adapter found on the system.\n\n");
	}
	do
	{
		Command_List();
		fgets(line_cmd, sizeof(line_cmd), stdin);
		sscanf(line_cmd, "%c", &cmd_0);

		switch (cmd_0)
		{
			case '1':
				nvalue = 0x55;
				printf("Output Data : [ 0x%x ]", nvalue);
				pcitg_mbout(ptg_board_0, nvalue);
				break;
			case '2':
				nvalue = 0xAA;
				pcitg_mbout(ptg_board_0, nvalue);
				printf("Output Data : [ 0x%x ]", nvalue);
				break;
			case '3':
				pcitg_mbin(ptg_board_0, &nvalue);
				nvalue &= 0xFF;
				printf("Input Data : [ 0x%x ]", nvalue);
				break;
			case 'Q':
			case 'q':
				printf(" Q : Exit\n\n");
				exit = 1;

				if (ptg_board_0 != 0)
					pcitg_close(ptg_board_0);

				break;

			default:
				printf(">> Not Support !");
				break;
		}
		printf("\n\n");
		//printf(">");

	} while (exit == 0);

	system("pause");

	return 0;
}
